﻿using UnityEngine;
using UnityEngine.UI;

public class CanvasLog : MonoBehaviour
{
    private string output = "";
    public Text txtOutput;

    void OnEnable()
    {
        Application.logMessageReceived += HandleLog;
    }

    void OnDisable()
    {
        Application.logMessageReceived -= HandleLog;
    }

    void HandleLog(string logString, string stackTrace, LogType type)
    {
        output = logString;
        if (txtOutput != null)
        {
            txtOutput.text = output;
            if (txtOutput.enabled == false)
            {
                txtOutput.enabled = true;
                Invoke("HideInfo", 5f);
            }
        }
    }

    private void Hide()
    {
        if (txtOutput != null)
        {
            txtOutput.enabled = false;

        }
    }
}
